############################################################################
# File name: AdauraControlLib_test.py                                      #
# Python: 2.x/3.x                                                          #
# Dependencies: pythonnet                                                  #
############################################################################

import clr
clr.AddReference('AdauraControlLib')
from AdauraControlLib import Lib

print("\nAdauraControl Library version \"%s\"\n" % Lib.Version())
Lib.EnumerateDevices()
print("Detecting connected devices...")
count = Lib.GetDevicesCount()
if count:
    print("%d device(s) found" % count)
    for i in range(count):
        print("Connected device %d:" % i)
        Lib.SetActiveDevice(i)
        print("\tDevice path: %s" % Lib.GetDevicePath(i))
        print("\tSerial No: %s" % Lib.GetSerial())
        print("\tModel: %s" % Lib.GetModel())
        print("\tChannels Count: %d" % Lib.GetChannelsCount())
        arr = Lib.GetAttenuations([])
        print("\tAttenuations: " + " ".join(str(x) for x in arr[1]))
else:
    printf("No connected devices found")